/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DeeprushEffect
extends MobEffect {
    private static final int RADIUS = 10;

    public DeeprushEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_6084_()) {
            int finalAmplifier;
            Level world = player.m_9236_();
            List nearbyPlayers = world.m_6443_(Player.class, player.m_20191_().m_82400_(10.0), this::isAffectedEntity);
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(player.m_146904_(), playerCount)) > 0) {
                nearbyPlayers.stream().filter(p -> p.m_6084_() && p != player && !p.m_7500_()).forEach(p -> this.applyDigSpeedEffect((Player)p, finalAmplifier));
            }
        }
    }

    private int calculateFinalAmplifier(int y, int playerCount) {
        int baseAmplifier = this.determineBaseAmplifierByYLevel(y);
        if (playerCount <= 0) {
            return baseAmplifier;
        }
        return Math.max(0, baseAmplifier / playerCount);
    }

    private int determineBaseAmplifierByYLevel(int y) {
        if (y >= 50) {
            return 0;
        }
        if (y >= 30) {
            return 1;
        }
        if (y >= 0) {
            return 2;
        }
        if (y >= -20) {
            return 3;
        }
        return 4;
    }

    private void applyDigSpeedEffect(Player player, int amplifier) {
        MobEffectInstance newEffect;
        MobEffectInstance currentEffect = player.m_21124_(MobEffects.f_19598_);
        if (this.shouldUpdateEffect(currentEffect, newEffect = new MobEffectInstance(MobEffects.f_19598_, 200, amplifier, false, false, false))) {
            player.m_21195_(MobEffects.f_19598_);
            player.m_7292_(newEffect);
        }
    }

    private boolean shouldUpdateEffect(MobEffectInstance currentEffect, MobEffectInstance newEffect) {
        return currentEffect == null || currentEffect.m_19564_() != newEffect.m_19564_();
    }

    private boolean isAffectedEntity(Player player) {
        return player.m_6084_() && !player.m_7500_();
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

